/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.formatter.preferences.IFieldValidator;
import com.aptana.formatter.preferences.IPreferenceDelegate;
import com.aptana.formatter.ui.epl.FormatterUIEplPlugin;
import com.aptana.formatter.ui.util.IStatusChangeListener;
import com.aptana.formatter.ui.util.StatusInfo;
import com.aptana.formatter.ui.util.StatusUtil;
import com.aptana.formatter.ui.widgets.CListViewer;
import com.aptana.formatter.ui.widgets.IListDataChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ControlBindingManager {
    private IStatusChangeListener changeListener;
    private Map<Button, Object> checkBoxControls;
    private Map<Combo, Object> comboControls;
    private final Map<Combo, IComboSelectedValueProvider> comboValueProviders = new IdentityHashMap<Combo, IComboSelectedValueProvider>();
    private DependencyManager dependencyManager;
    private IPreferenceDelegate preferenceDelegate;
    private Map<Button, String> radioControls;
    private Map<Spinner, Object> spinnerControls;
    private Map<CListViewer, Object> listControls;
    private Map<Text, Object> textControls;
    private ValidatorManager validatorManager;
    public static final DependencyMode DEPENDENCY_INVERSE_SELECTION = new DependencyMode();

    public ControlBindingManager(IPreferenceDelegate delegate, IStatusChangeListener listener) {
        this.checkBoxControls = new HashMap<Button, Object>();
        this.comboControls = new HashMap<Combo, Object>();
        this.textControls = new HashMap<Text, Object>();
        this.radioControls = new HashMap<Button, String>();
        this.spinnerControls = new HashMap<Spinner, Object>();
        this.listControls = new HashMap<CListViewer, Object>();
        this.validatorManager = new ValidatorManager();
        this.dependencyManager = new DependencyManager();
        this.changeListener = listener;
        this.preferenceDelegate = delegate;
    }

    public void bindControl(final Combo combo, Object key) {
        this.bindControl(combo, key, new IComboSelectedValueProvider(){

            public String getValueAt(int index) {
                return index >= 0 && index < combo.getItemCount() ? combo.getItem(index) : null;
            }

            public int indexOf(String value) {
                String[] items = combo.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(value)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }

    public void bindControl(Combo combo, Object key, final String[] itemValues) {
        this.bindControl(combo, key, new IComboSelectedValueProvider(){

            public String getValueAt(int index) {
                return itemValues[index];
            }

            public int indexOf(String value) {
                int i = 0;
                while (i < itemValues.length) {
                    if (itemValues[i].equals(value)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }

    public void bindControl(final Combo combo, final Object key, final IComboSelectedValueProvider itemValueProvider) {
        if (key != null) {
            this.comboControls.put(combo, key);
        }
        this.comboValueProviders.put(combo, itemValueProvider);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                ControlBindingManager.this.preferenceDelegate.setString(key, itemValueProvider.getValueAt(index));
                ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
            }
        });
    }

    public void bindControl(final Spinner spinner, final Object key) {
        if (key != null) {
            this.spinnerControls.put(spinner, key);
        }
        spinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ControlBindingManager.this.preferenceDelegate.setString(key, spinner.getText());
                ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
            }
        });
    }

    public void bindControl(final Button button, final Object key, Control[] slaves) {
        if (key != null) {
            this.checkBoxControls.put(button, key);
        }
        this.createDependency(button, slaves);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean state = button.getSelection();
                ControlBindingManager.this.preferenceDelegate.setBoolean(key, state);
                ControlBindingManager.this.updateStatus(StatusInfo.OK_STATUS);
            }
        });
    }

    public void bindControl(final Text text, final Object key, IFieldValidator validator) {
        if (key != null) {
            if (this.textControls.containsKey(key)) {
                IllegalArgumentException error = new IllegalArgumentException("Duplicate control " + key);
                IdeLog.logError((Plugin)FormatterUIEplPlugin.getDefault(), (Throwable)error, (String)"com.aptana.formatter.epl/debug");
                if (FormatterUIEplPlugin.DEBUG) {
                    throw error;
                }
            }
            this.textControls.put(text, key);
        }
        if (validator != null) {
            this.validatorManager.registerValidator(text, validator);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStatus status = ControlBindingManager.this.validateText(text);
                if (key != null && status.getSeverity() != 4) {
                    String value = text.getText();
                    ControlBindingManager.this.preferenceDelegate.setString(key, value);
                }
                ControlBindingManager.this.updateStatus(status);
            }
        });
    }

    public void bindRadioControl(Button button, final String key, final Object enable, Control[] dependencies) {
        if (key != null) {
            this.radioControls.put(button, key);
        }
        this.createDependency(button, dependencies);
        button.setData((Object)String.valueOf(enable));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = String.valueOf(enable);
                ControlBindingManager.this.preferenceDelegate.setString((Object)key, value);
            }
        });
    }

    public void bindControl(CListViewer list, final Object key) {
        if (key != null) {
            this.listControls.put(list, key);
        }
        list.addListDataChangeListener(new IListDataChangeListener(){

            public void inputChanged(Object input, Object oldInput) {
                Object[] in = (Object[])input;
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < in.length) {
                    builder.append(in[i]);
                    if (i + 1 < in.length) {
                        builder.append("!");
                    }
                    ++i;
                }
                String oldValue = ControlBindingManager.this.preferenceDelegate.getString(key);
                String newValue = builder.toString();
                if (!newValue.equals(oldValue)) {
                    ControlBindingManager.this.preferenceDelegate.setString(key, newValue);
                    ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
                }
            }
        });
    }

    public void createDependency(Button button, Control[] dependencies) {
        this.createDependency(button, dependencies, null);
    }

    public void createDependency(Button button, Control[] dependencies, DependencyMode mode) {
        if (dependencies != null) {
            this.dependencyManager.createDependency(button, dependencies, mode);
        }
    }

    public IStatus getStatus() {
        IStatus status = StatusInfo.OK_STATUS;
        Iterator<Text> iter = this.textControls.keySet().iterator();
        while (iter.hasNext()) {
            IStatus s = this.validateText(iter.next());
            status = StatusUtil.getMoreSevere(s, status);
        }
        return status;
    }

    public void initialize() {
        this.initTextControls();
        this.initCheckBoxes();
        this.initRadioControls();
        this.initCombos();
        this.initSpinners();
        this.initListControls();
        this.dependencyManager.initialize();
    }

    protected void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            Iterator<Text> iter = this.textControls.keySet().iterator();
            while (iter.hasNext()) {
                IStatus s = this.validateText(iter.next());
                status = StatusUtil.getMoreSevere(s, status);
            }
        }
        this.changeListener.statusChanged(status);
    }

    private void initCheckBoxes() {
        for (Button button : this.checkBoxControls.keySet()) {
            Object key = this.checkBoxControls.get(button);
            button.setSelection(this.preferenceDelegate.getBoolean(key));
        }
    }

    private void initCombos() {
        for (Map.Entry<Combo, Object> entry : this.comboControls.entrySet()) {
            Combo combo = entry.getKey();
            Object key = entry.getValue();
            String value = this.preferenceDelegate.getString(key);
            IComboSelectedValueProvider valueProvider = this.comboValueProviders.get(combo);
            if (valueProvider == null) continue;
            int index = valueProvider.indexOf(value);
            if (index >= 0) {
                combo.select(index);
                continue;
            }
            combo.select(0);
        }
    }

    private void initSpinners() {
        for (Spinner spinner : this.spinnerControls.keySet()) {
            Object key = this.spinnerControls.get(spinner);
            String value = this.preferenceDelegate.getString(key);
            if (StringUtil.isEmpty((String)value)) continue;
            spinner.setSelection(Integer.parseInt(value));
        }
    }

    private void initRadioControls() {
        for (Button button : this.radioControls.keySet()) {
            String key = this.radioControls.get(button);
            String enable = (String)button.getData();
            String value = this.preferenceDelegate.getString((Object)key);
            if (enable != null && enable.equals(value)) {
                button.setSelection(true);
                continue;
            }
            button.setSelection(false);
        }
    }

    private void initListControls() {
        for (CListViewer list : this.listControls.keySet()) {
            Object key = this.listControls.get((Object)list);
            String value = this.preferenceDelegate.getString(key);
            String[] elements = value != null ? value.split("!") : new String[]{};
            list.setInput(elements);
        }
    }

    private void initTextControls() {
        for (Text text : this.textControls.keySet()) {
            Object key = this.textControls.get(text);
            String value = this.preferenceDelegate.getString(key);
            text.setText(value);
        }
    }

    protected IStatus validateText(Text text) {
        IFieldValidator validator = this.validatorManager.getValidator(text);
        if (validator != null && text.isEnabled()) {
            return validator.validate(text.getText());
        }
        return StatusInfo.OK_STATUS;
    }

    class DependencyManager {
        private List<SelectionListener> masterSlaveListeners = new ArrayList<SelectionListener>();

        DependencyManager() {
        }

        public void createDependency(final Button master, final Control[] slaves, final DependencyMode mode) {
            SelectionListener listener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean state = master.getSelection();
                    if (mode == DEPENDENCY_INVERSE_SELECTION) {
                        state = !state;
                    }
                    int i = 0;
                    while (i < slaves.length) {
                        slaves[i].setEnabled(state);
                        ++i;
                    }
                    ControlBindingManager.this.changeListener.statusChanged(StatusInfo.OK_STATUS);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            master.addSelectionListener(listener);
            this.masterSlaveListeners.add(listener);
        }

        public void initialize() {
            Iterator<SelectionListener> it = this.masterSlaveListeners.iterator();
            while (it.hasNext()) {
                it.next().widgetSelected(null);
            }
        }
    }

    public static class DependencyMode {
    }

    public static interface IComboSelectedValueProvider {
        public String getValueAt(int var1);

        public int indexOf(String var1);
    }

    class ValidatorManager {
        private Map<Text, IFieldValidator> map = new HashMap<Text, IFieldValidator>();

        ValidatorManager() {
        }

        public IFieldValidator getValidator(Text text) {
            return this.map.get(text);
        }

        public void registerValidator(Text text, IFieldValidator validator) {
            this.map.put(text, validator);
        }

        public void unregisterValidator(Text text) {
            this.map.remove(text);
        }
    }
}

